import { PicSourceNyanConfig } from './config';
import { DefinePlugin } from 'koishi-thirdeye';
import { PicSourcePlugin } from 'koishi-plugin-pics';
import { NyanResult } from './def';
export * from './config';

@DefinePlugin({ name: 'picsource-nyan' })
export default class PicSourceNyan extends PicSourcePlugin(
  PicSourceNyanConfig,
) {
  async randomPic(tags: string[]) {
    const params = new URLSearchParams();
    params.append('r18', this.config.r18 ? 'true' : 'false');
    if (tags.length) {
      if (tags.length === 1) {
        params.append('keyword', tags[0]);
      } else {
        tags.forEach((tag) => params.append('tag', tag));
      }
    }
    const result = await this.http.get<NyanResult>(
      'https://sex.nyan.xyz/api/v2/',
      { params },
    );
    if (!result?.data?.length) {
      return;
    }
    const data = result.data[0];
    return {
      url: data.url,
      description: `PID:${data.pid} ${data.title} by ${data.author}`,
    };
  }
}
