import { PicSourceMiraikoiConfig } from './config';
import { DefinePlugin, Inject } from 'koishi-thirdeye';
import { Quester } from 'koishi';
import { PicResult, PicSourcePlugin } from 'koishi-plugin-pics';
export * from './config';

@DefinePlugin()
export default class PicSourceMiraikoi extends PicSourcePlugin(
  PicSourceMiraikoiConfig,
) {
  async randomPic(picTags: string[]): Promise<PicResult> {
    const { pic } = await this.http.get<{ pic: string }>(this.config.endpoint, {
      params: {
        type: 'json',
        sort: picTags[0] ?? this.config.defaultSort,
      },
    });
    if (!pic) {
      return;
    }
    return { url: pic };
  }
}
