import { SchemaProperty, RegisterSchema } from 'koishi-thirdeye';

@RegisterSchema()
export class PicSourceMiraikoiConfig {
  @SchemaProperty({ description: '图源名称。', default: 'miraikoi' })
  name: string;

  @SchemaProperty({
    description: '图源 API 地址。',
    default: 'https://iw233.cn/api.php',
  })
  endpoint: string;

  @SchemaProperty({
    description: '默认图片类型。',
    default: 'random',
  })
  defaultSort: string;
}

export type PicSourceMiraikoiConfigLike = Partial<PicSourceMiraikoiConfig>;
