// import 'source-map-support/register';
import { Quester, Random } from 'koishi';
import { PicSourceHeisiConfig } from './config';
import { DefinePlugin, Inject } from 'koishi-thirdeye';
import { PicSourcePlugin } from 'koishi-plugin-pics';
import AragamiPlugin, { CacheKey } from 'koishi-plugin-cache-aragami';
export * from './config';

class HeisiList {
  list: string[];

  @CacheKey()
  identifier() {
    return 'heisi';
  }

  isAvailable() {
    return !!this.list?.length;
  }
}

@DefinePlugin()
export default class PicSourceHeisi extends PicSourcePlugin(
  PicSourceHeisiConfig,
) {
  @Inject(true)
  private aragami: AragamiPlugin;

  @Inject(true)
  private http: Quester;

  onApply() {
    this.getRandomUrl().then();
  }

  async randomPic() {
    const url = await this.getRandomUrl();
    if (!url) return;
    return {
      url,
      description: this.config.picDescription,
    };
  }

  async getRandomUrl() {
    let list = await this.aragami.get(HeisiList, 'heisi');
    if (!list?.isAvailable()) {
      await this.fetchPicList();
      list = await this.aragami.get(HeisiList, 'heisi');
    }
    if (!list?.isAvailable()) {
      return;
    }
    return Random.pick(list.list);
  }

  async fetchPicList() {
    this.logger.info(`Fetching pic list from ${this.config.endpoint}...`);
    try {
      const content = await this.http.get<string>(this.config.endpoint);
      const urls = content
        .trim()
        .split('\n')
        .map((line) => line.trim())
        .filter((line) => line.startsWith('http'));
      await this.aragami.set(HeisiList, { list: urls });
      this.logger.info(
        `fetched ${urls.length} pics from ${this.config.endpoint}`,
      );
    } catch (e) {
      this.logger.error(
        `Failed to fetch pic list from ${
          this.config.endpoint
        }: ${e.toString()}`,
      );
    }
  }
}
