// import 'source-map-support/register';
import { DefineSchema, RegisterSchema } from 'koishi-thirdeye';

@RegisterSchema()
export class PicSourceHeisiConfig {

  @DefineSchema({ description: '图源名称', default: 'heisi' })
  name: string;

  @DefineSchema({
    description: '黑丝的图源地址。',
    default:
      'https://cdn.jsdelivr.net/gh/yzyyz1387/blogimages/nonebot/heisi.txt',
    role: 'url',
  })
  endpoint: string;

  @DefineSchema({
    description: '图源的有效时间，单位毫秒。',
    default: 24 * 3600 * 1000,
  })
  ttl: number;

  @DefineSchema({
    description: '图片描述。',
    default: '黑丝',
  })
  picDescription: string;
}

export type PicSourceHeisiConfigLike = Partial<PicSourceHeisiConfig>;
