// import 'source-map-support/register';
import { Quester, Cache, Random } from 'koishi';
import { PicsourceHeisiConfig } from './config';
import { DefinePlugin, Inject } from 'koishi-thirdeye';
import { PicSourcePlugin } from 'koishi-plugin-pics';
export * from './config';

declare module 'koishi' {
  // eslint-disable-next-line @typescript-eslint/no-namespace
  namespace Cache {
    interface Tables {
      heisiList: string[];
    }
  }
}

@DefinePlugin({ name: 'picsource-heisi', schema: PicsourceHeisiConfig })
export default class PicsourceHeisi extends PicSourcePlugin<PicsourceHeisiConfig> {
  @Inject('cache', true)
  private cache: Cache;

  @Inject(true)
  private http: Quester;

  onApply() {
    this.cache.table('heisiList', { maxAge: this.config.ttl });
    this.getRandomUrl().then();
    super.onApply();
  }

  async randomPic() {
    const url = await this.getRandomUrl();
    if (!url) return;
    return {
      url,
      description: this.config.picDescription,
    };
  }

  async getRandomUrl() {
    let list = await this.cache.get('heisiList', 'list');
    if (!list || !list.length) {
      await this.fetchPicList();
      list = await this.cache.get('heisiList', 'list');
    }
    if (!list || !list.length) {
      return;
    }
    return Random.pick(list);
  }

  async fetchPicList() {
    this.logger.info(`Fetching pic list from ${this.config.endpoint}...`);
    try {
      const content = await this.http.get(this.config.endpoint);
      const urls = content
        .trim()
        .split('\n')
        .map((line) => line.trim())
        .filter((line) => line.startsWith('http'));
      await this.cache.set('heisiList', 'list', urls);
      this.logger.info(
        `fetched ${urls.length} pics from ${this.config.endpoint}`,
      );
    } catch (e) {
      this.logger.error(
        `Failed to fetch pic list from ${
          this.config.endpoint
        }: ${e.toString()}`,
      );
    }
  }
}
