import 'source-map-support/register';
import { DefineSchema, RegisterSchema } from 'schemastery-gen';
import { PicSourceInfo } from 'koishi-plugin-pics';

@RegisterSchema()
export class PicsourceHeisiConfig implements PicSourceInfo {
  constructor(config: PicsourceHeisiConfigLike) {}

  @DefineSchema({ type: 'string', default: [], description: '图源标签' })
  tags: string[];
  @DefineSchema({ default: 1, description: '图源权重' })
  weight: number;
  @DefineSchema({ description: '图源描述' })
  description?: string;
  @DefineSchema({ description: '是否为默认图源' })
  isDefault?: boolean;

  // 给目标对象注入上述对象。
  applyTo(target: PicSourceInfo) {
    target.tags = this.tags;
    target.weight = this.weight;
    target.name = this.name;
    target.description = this.description;
    target.isDefault = this.isDefault;
  }

  @DefineSchema({ description: '图源名称', default: 'heisi' })
  name: string;

  @DefineSchema({
    description: '黑丝的图源地址。',
    default:
      'https://cdn.jsdelivr.net/gh/yzyyz1387/blogimages/nonebot/heisi.txt',
  })
  endpoint: string;

  @DefineSchema({
    description: '图源的有效时间，单位毫秒。',
    default: 24 * 3600 * 1000,
  })
  ttl: number;

  @DefineSchema({
    description: '图片描述。',
    default: '黑丝',
  })
  picDescription: string;
}

export type PicsourceHeisiConfigLike = Partial<PicsourceHeisiConfig>;
