// import 'source-map-support/register';
import { PicApiConfig } from './config';
import {
  DefinePlugin,
  Inject,
  KoaContext,
  Post,
  StarterPlugin,
} from 'koishi-thirdeye';
import PicsContainer from 'koishi-plugin-pics';
export * from './config';

type MayBeArray<T> = T | T[];

function makeArray<T>(value: MayBeArray<T>): T[] {
  if (!value) {
    return [];
  }
  return Array.isArray(value) ? value : [value];
}

interface RequestBody {
  picTags: MayBeArray<string>;
  sourceTags: MayBeArray<string>;
}

@DefinePlugin()
export default class PicApi extends StarterPlugin(PicApiConfig) {
  @Inject(true)
  private pics: PicsContainer;

  @Post('{{path}}')
  async handle(ctx: KoaContext) {
    if (this.config.token) {
      let authorization = ctx.headers.authorization;
      if (authorization.startsWith('Bearer ')) {
        authorization = authorization.slice(7);
      }
      if (authorization !== this.config.token) {
        ctx.status = 401;
        ctx.body = { error: 'Invalid token' };
        return;
      }
    }
    const { picTags, sourceTags } = ctx.request.body as RequestBody;
    const result = await this.pics.randomPic(
      makeArray(picTags),
      makeArray(sourceTags),
    );
    if (result) {
      ctx.status = 200;
      ctx.body = result;
    } else {
      ctx.status = 404;
      ctx.body = { error: 'No pics found' };
    }
  }
}
