// import 'source-map-support/register';
import { DefineSchema, RegisterSchema } from 'koishi-thirdeye';
import { segment, Session } from 'koishi';

@RegisterSchema()
export class OrderPickerConfig {
  constructor(config: OrderPickerConfigLike) {}

  @DefineSchema({ type: String, description: '目标群。', required: true })
  targetGuilds: string[];

  @DefineSchema({ type: String, description: '发布人。', required: true })
  publishers: string[];

  @DefineSchema({ description: '主人 ID。', required: true })
  masterId: string;

  @DefineSchema({
    type: String,
    description: '不接的关键词列表。',
    default: [],
  })
  blacklistMatchers: string[];

  @DefineSchema({ description: '抢单的文本。', default: '我要' })
  pickWord: string;

  isMatchingTarget(session: Session) {
    return (
      session.content &&
      session.guildId &&
      this.targetGuilds.includes(session.guildId.toString())
    );
  }

  acceptMessage(session: Session) {
    if (!session.userId || !this.publishers.includes(session.userId)) {
      return false;
    }
    if (
      this.blacklistMatchers.some((matcher) => session.content.match(matcher))
    ) {
      return false;
    }
    const segments = segment.parse(session.content);
    if (!segments.find((s) => s.type === 'at' && s.data.type === 'all')) {
      return false;
    }
    return true;
  }
}

export type OrderPickerConfigLike = Partial<OrderPickerConfig>;
