// import 'source-map-support/register';
import { NbnhhshPluginConfig } from './config';
import {
  CommandExample,
  DefinePlugin,
  Inject,
  PutArg,
  StarterPlugin,
  UseCommand,
} from 'koishi-thirdeye';
import { Quester } from 'koishi';
export * from './config';

interface NbnhhshData {
  name: string;
  trans: string[];
}

@DefinePlugin({ name: 'nbnhhsh' })
export default class NbnhhshPlugin extends StarterPlugin(NbnhhshPluginConfig) {
  @Inject(true)
  private http: Quester;

  @UseCommand('short <expr>', '查询缩写')
  @CommandExample('nbnhhsh nnhr')
  async shortCommand(@PutArg(0) expr: string) {
    if (!expr) return '缩写不能为空。';
    const data = await this.http.post<NbnhhshData[]>(this.config.endpoint, {
      text: expr,
    });
    if (!data?.length) {
      return `${expr}: Not found`;
    }
    return data
      .map((entry) => `${entry.name}: ${entry.trans.join(', ')}`)
      .join('\n');
  }
}
