import {
  DefineModel,
  DefinePlugin,
  Inject,
  ModelField,
  PrimaryGenerated,
  Provide,
  StarterPlugin,
  UseEvent,
  UseModel,
} from 'koishi-thirdeye';
import { Context, Session } from 'koishi';
import {} from '@koishijs/assets';

declare module 'koishi' {
  interface Tables {
    messageRecord: MessageRecord;
  }

  interface Context {
    msgdb: MessageDatabasePlugin;
  }
}

@DefineModel('messageRecord')
class MessageRecord implements Partial<Omit<Session, 'id'>> {
  @PrimaryGenerated()
  @ModelField('integer(11)')
  id: number;

  @ModelField('string')
  platform: string;

  @ModelField('string')
  selfId: string;

  @ModelField('string')
  userId: string;

  @ModelField('string')
  channelId: string;

  @ModelField('string')
  username: string;

  @ModelField('string')
  channelName: string;

  @ModelField('boolean')
  isPrivate: boolean;

  @ModelField('string(10000)')
  content: string;

  @ModelField('string')
  messageId: string;

  @ModelField('timestamp')
  date: Date;

  fromSession(session: Session) {
    this.platform = session.platform;
    this.selfId = session.selfId;
    this.userId = session.userId;
    this.channelId = session.channelId;
    this.username = session.username;
    this.channelName = session.channelName;
    this.isPrivate = session.subtype === 'private';
    this.messageId = session.messageId;
    this.content = session.content;
    this.date = new Date();
  }
}

@Provide('msgdb')
@UseModel(MessageRecord)
@DefinePlugin({ name: 'msgdb' })
export default class MessageDatabasePlugin extends StarterPlugin() {
  @Inject(true)
  private database: Context['database'];

  @Inject()
  private assets: Context['assets'];

  @UseEvent('message')
  private async onMessage(session: Session) {
    const record = new MessageRecord();
    record.fromSession(session);
    if (this.assets) {
      record.content = await this.assets.transform(record.content);
    }
    await this.database.create('messageRecord', record);
  }
}
