import { App } from 'koishi';
import TargetPlugin from '../src';
import ConsolePlugin from '@koishijs/plugin-console';
import * as SandboxPlugin from '@koishijs/plugin-sandbox';
import DatabasePlugin from '@koishijs/plugin-database-mysql';
import * as Help from '@koishijs/plugin-help';
import ExtrasInDev from './extras';
import DataviewPlugin from '@koishijs/plugin-dataview';

const app = new App({
  port: 14514,
  host: 'localhost',
  prefix: '.',
});

app.plugin(Help);

// Console and sandbox
app.plugin(SandboxPlugin);
app.plugin(ConsolePlugin, {
  open: false,
});

// Some services
app.plugin(DatabasePlugin, {
  host: '127.0.0.1',
  user: 'root',
  password: 'koishi',
  database: 'koishi',
});
app.plugin(DataviewPlugin);

// Some extras
app.plugin(ExtrasInDev);

// Target plugin
app.plugin(TargetPlugin, {});

app.start();
