import 'source-map-support/register';
import { Context, MaybeArray, Schema } from 'koishi';

const selectors = [
  'user',
  'guild',
  'channel',
  'self',
  'private',
  'platform',
] as const;

type SelectorType = typeof selectors[number];
type SelectorValue = boolean | MaybeArray<string | number>;
type BaseSelection = { [K in SelectorType as `$${K}`]?: SelectorValue };

export interface Selection extends BaseSelection {
  $and?: Selection[];
  $or?: Selection[];
  $not?: Selection;
}

export type Config = Selection;

export class MyPlugin {
  config: Config;
  ctx: Context;
  name = 'limit-help-main';
  schema: Schema<Selection> = Schema.any('帮助作用域。').default({
    $user: '10000',
  });
  apply(ctx: Context, config: Config) {
    this.ctx = ctx;
    this.config = config;
    this.disableHelp();
  }
  disableHelp() {
    const helpCommand = this.ctx.command('help');
    if (!helpCommand) {
      return;
    }
    const helpCtx = helpCommand.context;
    helpCommand.context = helpCtx.intersect(this.ctx.select(this.config));
  }
}
