import 'source-map-support/register';
import { Context, Selection, Schema } from 'koishi';

export type PluginConfig = Selection;

export class MyPlugin {
  config: PluginConfig;
  ctx: Context;
  name = 'limit-help-main';
  schema: Schema<Selection> = Schema.any().description('帮助作用域').default({
    $user: '10000',
  });
  apply(ctx: Context, config: PluginConfig) {
    this.ctx = ctx;
    this.config = config;
    this.disableHelp();
  }
  disableHelp() {
    const helpCommand = this.ctx.command('help');
    if (!helpCommand) {
      return;
    }
    const helpCtx = helpCommand.context;
    helpCommand.context = helpCtx.intersect(this.ctx.select(this.config));
  }
}
