import { DomainInfo, DomainState, Hypervisor } from '@avaflow/libvirt';

export const getDomainsFromHypervisor = async (hypervisor: Hypervisor) => {
  const domains = await hypervisor.connectListAllDomains();
  return Promise.all(
    domains.map(async (domain) => {
      const [id, info, name, uuid] = (await Promise.all([
        hypervisor.domainGetID(domain),
        hypervisor.domainGetInfo(domain),
        hypervisor.domainGetName(domain),
        hypervisor.domainGetUUIDString(domain),
        //hypervisor.domainGetXMLDesc(domain),
      ])) as [number, DomainInfo, string, string];
      return {
        id,
        domain,
        info,
        name,
        uuid,
      };
    }),
  );
};

export const DomainStateToText = (state: DomainState) => {
  switch (state) {
    case DomainState.NOSTATE:
      return '未知';
    case DomainState.RUNNING:
      return '运行中';
    case DomainState.BLOCKED:
      return '阻塞';
    case DomainState.PAUSED:
      return '暂停';
    case DomainState.SHUTDOWN:
      return '正在关机';
    case DomainState.SHUTOFF:
      return '已关闭';
    case DomainState.CRASHED:
      return '崩溃';
    case DomainState.PMSUSPENDED:
      return '暂停';
  }
};
