// import 'source-map-support/register';
import { GreetingPluginConfig, Instance } from './config';
import {
  DefinePlugin,
  StarterPlugin,
  Inject,
  LifecycleEvents,
  UseEvent,
} from 'koishi-thirdeye';
import { Adapter, Bot } from 'koishi';
import { Job, scheduleJob } from 'node-schedule';
import _ from 'lodash';
export * from './config';

@DefinePlugin({ name: 'greeting', schema: GreetingPluginConfig })
export default class GreetingPlugin
  extends StarterPlugin(GreetingPluginConfig)
  implements LifecycleEvents
{
  @Inject()
  private bots: Bot[];

  private job: Job;

  private pendingInstances = new Map<string, Instance[]>();

  private addPending(instance: Instance) {
    const instances = this.pendingInstances.get(instance.from) || [];
    instances.push(instance);
    this.pendingInstances.set(instance.from, instances);
  }

  @UseEvent('bot-status-updated')
  async onBotStatusUpdated(bot: Bot) {
    if (bot.status === 'online') {
      await this.resolvePending(bot.sid);
    }
  }

  private async resolvePending(from: string) {
    const instances = this.pendingInstances.get(from);
    if (!instances) return;
    this.pendingInstances.delete(from);
    return this.run(_.uniq(instances));
  }

  async run(instances?: Instance[]) {
    if (!instances) {
      this.pendingInstances.clear();
    }
    const failedInstances = await this.config.runInstances(
      this.bots,
      instances,
    );
    for (const instance of failedInstances) {
      this.addPending(instance);
    }
  }

  onConnect() {
    this.job = scheduleJob('0 * * * * *', () => this.run());
    this.job.invoke();
  }

  onDisconnect() {
    if (this.job) this.job.cancel();
  }
}
