// import 'source-map-support/register';
import { ElasticSearchPluginConfig } from './config';
import { DefinePlugin, Provide } from 'koishi-thirdeye';
import { Client, ClientOptions } from '@elastic/elasticsearch';
import { Context } from 'koishi';
export * from './config';

declare module 'koishi' {
  interface Context {
    elasticsearch: ElasticSearchPlugin;
  }
}

@Provide('elasticsearch', { immediate: true })
@DefinePlugin({ name: 'elasticsearch', schema: ElasticSearchPluginConfig })
export default class ElasticSearchPlugin extends Client {
  constructor(ctx: Context, config: ClientOptions) {
    super(config);
  }
}
