import 'source-map-support/register';
import { DefineSchema, RegisterSchema } from 'koishi-thirdeye';
import { ClientOptions, NodeOptions } from '@elastic/elasticsearch';
import { Schema } from 'koishi';

@RegisterSchema()
export class ElasticSearchPluginConfig implements ClientOptions {
  constructor(config: ClientOptions) {}

  @DefineSchema({
    type: Schema.union([
      Schema.string().description('Elasticsearch URL. '),
      Schema.array(Schema.string()),
      Schema.object({}),
      Schema.array(Schema.object({})),
    ]),
    required: true,
  })
  node: string | string[] | NodeOptions | NodeOptions[];
}
