import { Context } from 'koishi';
import PicsContainer from 'koishi-plugin-pics';
import PicSourceLolicon from 'koishi-plugin-picsource-lolicon';
import PicSourceYandePlugin from 'koishi-plugin-picsource-yande';
import PicSourceHeisi from 'koishi-plugin-picsource-heisi';
import PicSourceMiraikoi from 'koishi-plugin-picsource-miraikoi';

export default class ExtrasInDev {
  constructor(ctx: Context) {
    ctx.plugin(PicsContainer, { useBase64: true });
    ctx.plugin(PicSourceLolicon, {
      isDefault: true,
      weight: 2,
    });
    ctx.plugin(PicSourceYandePlugin, {
      name: 'yande',
      weight: 1,
      endpoint: 'https://yande.re/post.json',
      pageLimit: 200,
      isDefault: true,
    });
    ctx.plugin(PicSourceYandePlugin, {
      name: 'konachan',
      weight: 1,
      endpoint: 'https://konachan.com/post.json',
      pageLimit: 200,
      isDefault: true,
    });
    ctx.plugin(PicSourceHeisi, { isDefault: true });
    ctx.plugin(PicSourceMiraikoi, { isDefault: true });
  }
}
