import { Bot, Context, Random } from 'koishi';

export function sendPriv(bot: Bot, userId: string, content: string) {
  return bot.sendPrivateMessage
    ? bot.sendPrivateMessage(userId, content)
    : bot.sendMessage(`@${userId}`, content);
}

export function dynamicInterval(
  ctx: Context,
  callback: () => void,
  min: number,
  max: number,
) {
  return ctx.setTimeout(() => {
    callback();
    dynamicInterval(ctx, callback, min, max);
  }, Random.int(min, max));
}
