import { DicePluginConfig } from './config';
import {
  CommandDescription,
  DefinePlugin,
  Isolate,
  LifecycleEvents,
  UseCommand,
} from 'koishi-thirdeye';
import { DbModule } from './modules/db';
import { BaseModule } from './utility/base-module';
import { RollModule } from './modules/roll';
import { RcModule } from './modules/rc';
import { CompatModule } from './modules/compat';

export * from './config';

@Isolate('diceDb')
@DefinePlugin({ name: 'dicex', schema: DicePluginConfig })
export default class DicePlugin extends BaseModule implements LifecycleEvents {
  @UseCommand('dice', { empty: true })
  @CommandDescription({ zh: '骰子指令', en: 'Dice command' })
  // eslint-disable-next-line @typescript-eslint/no-empty-function
  diceCommand() {}

  onApply() {
    this.ctx.plugin(DbModule, this.config);
    this.ctx.plugin(RollModule, this.config);
    this.ctx.plugin(RcModule, this.config);
    this.ctx.plugin(CompatModule, this.config);
  }
}
