import {
  CommandAlias,
  CommandDescription,
  CommandExample,
  CommandShortcut,
  Inject,
  PutArg,
  PutSession,
  PutUserName,
  UseCommand,
} from 'koishi-thirdeye';
import { Channel, Session, User } from 'koishi';
import {
  DiceModule,
  getDefaultRollFaces,
  PutChannelProfile,
  PutUserProfile,
} from '../utility/utility';
import { BaseModule } from '../utility/base-module';
import { OneDice } from 'onedice';
import { DbModule } from './db';

@DiceModule()
export class RollModule extends BaseModule {
  @Inject()
  private diceDb: DbModule;

  @UseCommand('dice/roll [expr:string]', '掷骰')
  @CommandDescription({ en: 'Roll dice' })
  @CommandAlias('r')
  @CommandShortcut('掷骰', { fuzzy: true })
  @CommandExample('roll 2d6+d10')
  async onRoll(
    @PutUserName(true) username: string,
    @PutArg(0) message: string,
    @PutUserProfile() user: User,
    @PutChannelProfile() channel: Channel,
    @PutSession() session: Session,
  ) {
    if (!message) {
      message = `1d`;
    }

    const { maxPoint = 1 << 16, maxTimes = 64 } = this.config;
    let output = `${username} 掷骰：${message}=`;
    try {
      output += new OneDice({
        defaultDiceFaces: getDefaultRollFaces(user, channel),
        maxDiceCount: maxTimes,
        maxDiceFaces: maxPoint,
        valueDict: this.diceDb ? await this.diceDb.getAllSkills(session) : {},
      }).calculate(message);
    } catch (e) {
      return '表达式语法错误。';
    }
    return output;
  }
}
