import { DiceModule } from '../utility/utility';
import { BaseModule } from '../utility/base-module';
import { UseMiddleware } from 'koishi-thirdeye';
import { Next, Session } from 'koishi';

@DiceModule()
export class CompatModule extends BaseModule {
  private checkCommands = ['st', 'rc', 'ra', 'r'] as const;

  @UseMiddleware()
  onRollCompat(session: Session, next: Next) {
    if (!session.parsed) {
      return next();
    }
    const { content, prefix } = session.parsed;
    if (!prefix) {
      return next();
    }
    const matchingCommand = this.checkCommands.find((pattern) =>
      content.startsWith(pattern),
    );
    if (matchingCommand) {
      const rest = content.slice(matchingCommand.length);
      return session.execute(`${matchingCommand} ${rest}`, next);
    }
    return next();
  }
}
