import {
  CommandAlias,
  CommandDescription,
  CommandExample,
  CommandShortcut,
  CommandUsage,
  Inject,
  PutArg,
  PutSession,
  PutUserName,
  UseCommand,
} from 'koishi-thirdeye';
import { Channel, Random, Session, User } from 'koishi';
import {
  DiceModule,
  getRcMode,
  PutChannelProfile,
  PutUserProfile,
} from '../utility/utility';
import { BaseModule } from '../utility/base-module';
import { RcResult, RcRuleList } from '../utility/rc-rules';
import { DbModule } from './db';

@DiceModule()
export class RcModule extends BaseModule {
  private getRcRule(user: User, channel: Channel) {
    const index = getRcMode(user, channel);
    return RcRuleList[index];
  }

  @Inject()
  diceDb: DbModule;

  @UseCommand('dice/rc <reason:string> [rate:integer]')
  @CommandDescription({ zh: '检定', en: 'Roll check' })
  @CommandAlias('ra')
  @CommandShortcut('检定', { fuzzy: true })
  @CommandUsage('可以用 st 设置数值。')
  @CommandExample('rc 潜行 20')
  @CommandExample('rc 潜行')
  async onRc(
    @PutSession() session: Session,
    @PutUserName(true) username: string,
    @PutArg(0) reason: string,
    @PutArg(1) rate: number,
    @PutUserProfile() user: User,
    @PutChannelProfile() channel: Channel,
  ) {
    if (rate == null && this.diceDb) {
      rate = await this.diceDb.getSkillValue(session, reason);
    }
    if (rate == null || rate < 0 || rate > 100) {
      return '成功率必须在 0 到 100 之间。';
    }
    const rule = this.getRcRule(user, channel);
    const value = Random.int(1, 101);
    const result = rule.check(rate, value);
    const resultText =
      result === RcResult.BigFailure
        ? '大失败！'
        : result === RcResult.Failure
        ? '失败'
        : result === RcResult.Success
        ? '成功'
        : '大成功！';
    return `${username}要${reason}，开始进行检定：D100=${value}/${rate} ${resultText}`;
  }
}
