import { DiceModule } from '../utility/utility';
import { BaseModule } from '../utility/base-module';
import { UseMiddleware } from 'koishi-thirdeye';
import { Next, Session } from 'koishi';
import { rcRegexp, rollRegexp } from '../utility/constant';

@DiceModule()
export class CompatModule extends BaseModule {
  @UseMiddleware()
  onRollCompat(session: Session, next: Next) {
    if (!session.parsed) {
      return next();
    }
    const { content, prefix } = session.parsed;
    if (!prefix || content[0] !== 'r') return next();
    const expr = content.slice(1);
    if (rollRegexp.test(expr)) {
      return session.execute({ name: 'roll', args: [expr] });
    }
    if (rcRegexp.test(expr)) {
      const matching = expr.match(rcRegexp);
      return session.execute({
        name: 'rc',
        args: [
          matching[1],
          ...(matching[2] ? [parseInt(matching[2].trim())] : []),
        ],
      });
    }
    return next();
  }
}
