export enum RcResult {
  BigSuccess = 1,
  Success = 2,
  Failure = 3,
  BigFailure = 4,
}

export class RcRule {
  text: string;
  check(rate: number, value: number): RcResult {
    return value <= rate ? RcResult.Success : RcResult.Failure;
  }
}

export class RcRule0 extends RcRule {
  text = '出1大成功\n不满50出96-100大失败，满50出100大失败';
  check(rate: number, value: number): RcResult {
    if (value <= 1) {
      return RcResult.BigSuccess;
    }
    const res = super.check(rate, value);
    if (
      res === RcResult.Failure &&
      ((rate < 50 && value >= 96) || (rate >= 50 && value >= 100))
    ) {
      return RcResult.BigFailure;
    }
    return res;
  }
}

export class RcRule1 extends RcRule {
  text =
    '不满50出1大成功，满50出1-5大成功\n不满50出96-100大失败，满50出100大失败';
  check(rate: number, value: number): RcResult {
    const res = super.check(rate, value);
    if (res === RcResult.Success) {
      if ((rate < 50 && value <= 1) || (rate >= 50 && value <= 5)) {
        return RcResult.BigSuccess;
      }
    } else {
      if (
        ((rate < 50 && value >= 96) || (rate >= 50 && value >= 100)) &&
        res === RcResult.Failure
      ) {
        return RcResult.BigFailure;
      }
    }
    return res;
  }
}

export class RcRule2 extends RcRule {
  text = '出1-5且<=成功率大成功\n出100或出96-99且>成功率大失败';
  check(rate: number, value: number): RcResult {
    const res = super.check(rate, value);
    if (res === RcResult.Success) {
      if (value <= 5) {
        return RcResult.BigSuccess;
      }
    } else {
      if (value >= 96) {
        return RcResult.BigFailure;
      }
    }
    return res;
  }
}

export class RcRule3 extends RcRule {
  text = '出1-5大成功\n出96-100大失败';
  check(rate: number, value: number): RcResult {
    if (value <= 5) {
      return RcResult.BigSuccess;
    }
    if (value >= 96) {
      return RcResult.BigFailure;
    }
    return super.check(rate, value);
  }
}

export class RcRule4 extends RcRule {
  text =
    '出1-5且<=十分之一大成功\\n不满50出>=96+十分之一大失败，满50出100大失败';
  check(rate: number, value: number): RcResult {
    const res = super.check(rate, value);
    if (res === RcResult.Success) {
      if (value <= 5 && value <= rate / 10) {
        return RcResult.BigSuccess;
      }
    } else {
      if (
        (rate < 50 && value >= 96 + rate / 10) ||
        (rate >= 50 && value >= 100)
      ) {
        return RcResult.BigFailure;
      }
    }
    return res;
  }
}

export class RcRule5 extends RcRule {
  text = '出1-2且<五分之一大成功\\n不满50出96-100大失败，满50出99-100大失败';
  check(rate: number, value: number): RcResult {
    const res = super.check(rate, value);
    if (res === RcResult.Success) {
      if (value <= 2 && value <= rate / 5) {
        return RcResult.BigSuccess;
      }
    } else {
      if (
        (rate < 50 && value >= 96) ||
        (rate >= 50 && value >= 99 && value <= 100)
      ) {
        return RcResult.BigFailure;
      }
    }
    return res;
  }
}

export const RcRuleList: RcRule[] = [
  new RcRule0(),
  new RcRule1(),
  new RcRule2(),
  new RcRule3(),
  new RcRule4(),
  new RcRule5(),
];
