import {
  CommandAlias,
  CommandDescription,
  CommandExample,
  CommandShortcut,
  PutArg,
  PutChannel,
  PutUser,
  PutUserName,
  UseCommand,
} from 'koishi-thirdeye';
import { Channel, Random, User } from 'koishi';
import { DiceModule, getRcMode } from '../utility/utility';
import { BaseModule } from '../utility/base-module';
import { RcResult, RcRuleList } from '../utility/rc-rules';

@DiceModule()
export class RcModule extends BaseModule {
  private getRcRule(user: User, channel: Channel) {
    const index = getRcMode(user, channel);
    return RcRuleList[index];
  }

  @UseCommand('dice/rc <rate:integer> [reason:string]')
  @CommandDescription({ zh: '检定', en: 'Roll check' })
  @CommandAlias('ra')
  @CommandShortcut('检定', { fuzzy: true })
  @CommandExample('rc 20 潜行')
  onRc(
    @PutUserName(true) username: string,
    @PutArg(0) rate: number,
    @PutArg(1) reason: string,
    @PutUser(['diceRcMode']) user: User,
    @PutChannel(['diceRcMode']) channel: Channel,
  ) {
    if (!rate || rate < 0 || rate > 100) {
      return '成功率必须在 0 到 100 之间。';
    }
    const rule = this.getRcRule(user, channel);
    const value = Random.int(1, 101);
    const result = rule.check(rate, value);
    const resultText =
      result === RcResult.BigFailure
        ? '大失败！'
        : result === RcResult.Failure
        ? '失败'
        : result === RcResult.Success
        ? '成功'
        : '大成功！';
    return `${username}${
      reason ? `要${reason}，开始` : ''
    }进行检定：D100=${value}/${rate} ${resultText}`;
  }
}
