import { Model } from 'koishi';

export interface DiceProfile {
  diceRcMode: number;
  diceDefaultRollFaces: number;
}
export const DiceProfileFields: (keyof DiceProfile)[] = [
  'diceRcMode',
  'diceDefaultRollFaces',
];

export function getProfileModel(): Model.Field.Extension<DiceProfile> {
  return {
    diceRcMode: { type: 'integer' },
    diceDefaultRollFaces: { type: 'integer' },
  };
}
