import 'source-map-support/register';
import { RegisterSchema, SchemaProperty } from 'koishi-thirdeye';

@RegisterSchema()
export class DicePluginConfig {
  constructor(config: DicePluginConfigLike) {}

  @SchemaProperty({ description: '掷骰的最大点数。', default: 1 << 16 })
  maxPoint: number;

  @SchemaProperty({ description: '单次调用中最大掷骰次数。', default: 64 })
  maxTimes: number;
}

export type DicePluginConfigLike = Partial<DicePluginConfig>;
