import {
  CommandAlias,
  CommandExample,
  CommandShortcut,
  PutArg,
  PutChannel,
  PutUserName,
  UseCommand,
} from 'koishi-thirdeye';
import { Channel, Random } from 'koishi';
import { DiceModule } from '../utility/utility';
import { BaseModule } from '../utility/base-module';
import { RcResult, RcRuleList } from '../utility/rc-rules';

@DiceModule()
export class RcModule extends BaseModule {
  private getRcRule(channel: Channel) {
    const index = channel?.diceRcMode || 0;
    return RcRuleList[index];
  }

  @UseCommand('dice/rc <rate:integer> [reason:string]', '检定')
  @CommandAlias('ra')
  @CommandShortcut('检定', { fuzzy: true })
  @CommandExample('rc 20 潜行')
  onRc(
    @PutUserName(true) username: string,
    @PutArg(0) rate: number,
    @PutArg(1) reason: string,
    @PutChannel(['diceRcMode']) channel: Channel,
  ) {
    if (!rate || rate < 0 || rate > 100) {
      return '成功率必须在 0 到 100 之间。';
    }
    const rule = this.getRcRule(channel);
    const value = Random.int(1, 101);
    const result = rule.check(rate, value);
    const resultText =
      result === RcResult.BigFailure
        ? '大失败！'
        : result === RcResult.Failure
        ? '失败'
        : result === RcResult.Success
        ? '成功'
        : '大成功！';
    return `${username}${
      reason ? `要${reason}，开始` : ''
    }进行检定：D100=${value}/${rate} ${resultText}`;
  }
}
