import 'source-map-support/register';
import { DicePluginConfig } from './config';
import { KoishiPlugin, OnApply, UseCommand } from 'koishi-thirdeye';
import { DbModule } from './modules/db';
import { BaseModule } from './utility/base-module';
import { RollModule } from './modules/roll';
import { RcModule } from './modules/rc';
import { CompatModule } from './modules/compat';

export * from './config';

declare module 'koishi' {
  interface Modules {
    dicex: typeof import('.');
  }
  // eslint-disable-next-line @typescript-eslint/no-namespace
  namespace Context {
    interface Services {
      diceDb: DbModule;
    }
  }
}

@KoishiPlugin({ name: 'dicex', schema: DicePluginConfig })
export default class DicePlugin extends BaseModule implements OnApply {
  @UseCommand('dice', '骰子指令', { empty: true })
  // eslint-disable-next-line @typescript-eslint/no-empty-function
  diceCommand() {}

  onApply() {
    this.ctx.plugin(DbModule, this.config);
    this.ctx.plugin(RollModule, this.config);
    this.ctx.plugin(RcModule, this.config);
    this.ctx.plugin(CompatModule, this.config);
  }
}
