import { DefinePlugin, PutChannel, PutOption, PutUser } from 'koishi-thirdeye';
import { DicePluginConfig } from '../config';
import { Channel, User } from 'koishi';
import { DiceProfile, DiceProfileFields } from './dice-profile';

export const DiceModule = () => DefinePlugin({ schema: DicePluginConfig });

export function getProfileProperty<K extends keyof DiceProfile>(
  user: User,
  channel: Channel,
  property: K,
  defaultValue: DiceProfile[K],
) {
  if (user && user[property] != null) {
    return user[property];
  }
  if (channel && channel[property] != null) {
    return channel[property];
  }
  return defaultValue;
}

export const getRcMode = (user: User, channel: Channel) =>
  getProfileProperty(user, channel, 'diceRcMode', 0);

export const getDefaultRollFaces = (user: User, channel: Channel) =>
  getProfileProperty(user, channel, 'diceDefaultRollFaces', 6);

export const PutUserProfile = () => PutUser(DiceProfileFields);
export const PutChannelProfile = () => PutChannel(DiceProfileFields);

export const PutIsGlobal = () => PutOption('global', '-g  作用于本频道。');
