import { DefinePlugin, PutChannel, PutOption, PutUser } from 'koishi-thirdeye';
import { DicePluginConfig } from '../config';
import { Channel, User } from 'koishi';
import { DiceProfile } from './dice-profile';

export const DiceModule = () => DefinePlugin({ schema: DicePluginConfig });

export function getProfileProperty<K extends keyof DiceProfile>(
  user: User,
  channel: Channel,
  property: K,
  defaultValue: DiceProfile[K],
) {
  return (
    user?.diceProfile?.[property] ??
    channel?.diceProfile?.[property] ??
    defaultValue
  );
}

export const getRcMode = (user: User, channel: Channel) =>
  getProfileProperty(user, channel, 'rcMode', 0);

export const getDefaultRollFaces = (user: User, channel: Channel) =>
  getProfileProperty(user, channel, 'defaultRollFaces', 6);

export const PutUserProfile = () => PutUser(['diceProfile']);
export const PutChannelProfile = () => PutChannel(['diceProfile']);

export const PutIsGlobal = () => PutOption('global', '-g  作用于本频道。');
