// import 'source-map-support/register';
import { DiceKillerConfig } from './config';
import {
  DefinePlugin,
  InjectLogger,
  StarterPlugin,
  UseMiddleware,
} from 'koishi-thirdeye';
import { Logger, Next, Session } from 'koishi';
export * from './config';

@DefinePlugin()
export default class DiceKiller extends StarterPlugin(DiceKillerConfig) {
  @InjectLogger()
  private logger: Logger;

  @UseMiddleware()
  detectDice(session: Session, next: Next) {
    if (this.config.matchingMessage(session.content)) {
      this.logger.info(
        `Dice detected from ${session.userId} in ${session.channelId}.`,
      );
      return `${this.config.emitCommand} ${session.userId}`;
    }
    return next();
  }
}
