import { SchemaProperty, RegisterSchema } from 'koishi-thirdeye';

@RegisterSchema()
export class DiceKillerConfig {
  constructor(config: DiceKillerConfigLike) {}

  @SchemaProperty({
    description: '消息匹配。',
    type: String,
    default: ['Dice! by 溯洄'],
  })
  match: string[];

  @SchemaProperty({ description: '触发的指令。', default: '.dismiss' })
  emitCommand: string;

  matchingMessage(text: string) {
    if (!text) {
      return false;
    }
    return this.match.some((pattern) => text.match(pattern));
  }
}

export type DiceKillerConfigLike = Partial<DiceKillerConfig>;
