// import 'source-map-support/register';
import { CountdownPluginConfig } from './config';
import { Apply, DefinePlugin, Reusable } from 'koishi-thirdeye';
import { SchedulePlugin } from 'koishi-schedule-send';
export * from './config';

@Reusable()
@DefinePlugin()
export default class CountdownPlugin extends SchedulePlugin(
  CountdownPluginConfig,
) {
  current = 0;

  @Apply()
  initialize() {
    console.log(this.config.returnRate);
    this.current = this.config.getInitial();
  }

  async send() {
    if (!this.current) {
      if (this.config.shouldReturn()) {
        this.current = this.config.getInitial();
        return (this.current--).toString();
      }
      if (this.config.repeatOne) {
        return '1';
      }
      return '';
    } else {
      return (this.current--).toString();
    }
  }
}
