// import 'source-map-support/register';
import { Random, Schema } from 'koishi';
import { SchemaProperty, RegisterSchema } from 'koishi-thirdeye';

@RegisterSchema()
export class CountdownPluginConfig {
  constructor(config: CountdownPluginConfigLike) {}

  @SchemaProperty({ default: 5, description: '最小起始数值。', step: 1 })
  initialMin: number;

  @SchemaProperty({ default: 10, description: '最大起始数值。', step: 1 })
  initialMax: number;

  getInitial() {
    return Random.int(this.initialMin, this.initialMax + 1);
  }

  @SchemaProperty({ default: true, description: '是否重复 1 数值。' })
  repeatOne: boolean;

  @SchemaProperty({
    type: Schema.percent(),
    default: 0.4,
    description: '回弹的概率。',
  })
  returnRate: number;

  shouldReturn() {
    const value = Random.real(0, 1);
    return value < this.returnRate;
  }
}

export type CountdownPluginConfigLike = Partial<CountdownPluginConfig>;
