import { SchemaProperty, RegisterSchema } from 'koishi-thirdeye';
import type { openai, ChatGPTAPI, SendMessageOptions } from 'chatgpt';
import { Schema } from 'koishi';

@RegisterSchema()
export class ChatGPTApiPluginConfig {
  constructor(config: ChatGPTApiPluginConfigLike) {}

  @SchemaProperty({
    required: true,
    description: 'ChatGPT API Key. ',
    role: 'secret',
  })
  apiKey: string;

  @SchemaProperty({
    type: Schema.object({}),
    description: 'OpenAI API 额外选项。',
    default: {},
    hidden: true,
  })
  completionParams: Partial<openai.CompletionParams>;

  @SchemaProperty({ description: '模型名称。', default: 'text-davinci-003' })
  model: string;

  @SchemaProperty({
    type: Schema.object({}),
    default: {},
    description: 'ChatGPT API 额外选项。',
    hidden: true,
  })
  extras: Partial<ConstructorParameters<typeof ChatGPTAPI>[0]>;

  @SchemaProperty({
    type: Schema.object({}),
    default: {},
    description: '发送消息时的额外选项。',
    hidden: true,
  })
  sendOptions: Partial<SendMessageOptions>;

  @SchemaProperty({
    description: '会话超时时间（ms）。',
    default: 3600000,
  })
  sessionTTL: number;

  @SchemaProperty({
    description: '触发前缀。如果为空则任何时候都触发。',
    default: ['!', '！'],
    type: String,
  })
  prefix: string[];
}

export type ChatGPTApiPluginConfigLike = Partial<ChatGPTApiPluginConfig>;
