// import 'source-map-support/register';
import { AragamiConfig } from './config';
import {
  DefinePlugin,
  koishiRegistrar,
  LifecycleEvents,
  PartialDeep,
  PluginSchema,
  Provide,
} from 'koishi-thirdeye';
import { Channel, Command, Context, Session, User } from 'koishi';
import { Aragami, AragamiOptions, WrapDecoratorBuilder } from 'aragami';
export * from './config';
export * from 'aragami';

declare module 'koishi' {
  interface Context {
    aragami: AragamiPlugin;
  }
}

@PluginSchema(AragamiConfig)
@Provide('aragami', { immediate: true })
@DefinePlugin({ name: 'cache-aragami' })
export default class AragamiPlugin extends Aragami implements LifecycleEvents {
  constructor(
    ctx: Context,
    _config: PartialDeep<AragamiConfig> & AragamiOptions,
  ) {
    super(_config.getConfig());
  }

  onDisconnect() {
    return this.destroy();
  }

  private commandLock<C extends Command>(
    cmd: C,
    fields: string[],
    info: { idFactory: (session: Session) => string; prefix: string },
  ) {
    return cmd.action((argv) => {
      if (!argv.session) return argv.next();
      const id = info.idFactory(argv.session);
      if (!id) return argv.next();
      const lockFields = fields.map(
        (field) => `koishi:${info.prefix}:${id}:${field}`,
      );
      return this.lock(lockFields, argv.next);
    }, true);
  }

  commandUserLock<C extends Command>(cmd: C, fields: (keyof User)[]) {
    return this.commandLock(cmd.userFields(fields) as C, fields, {
      idFactory: (session: Session) => session.userId,
      prefix: 'user',
    });
  }

  commandChannelLock<C extends Command>(cmd: C, fields: (keyof Channel)[]) {
    return this.commandLock(cmd.channelFields(fields) as C, fields, {
      idFactory: (session: Session) => session.channelId,
      prefix: 'channel',
    });
  }

  commandGuildLock<C extends Command>(cmd: C, fields: (keyof Channel)[]) {
    return this.commandLock(cmd.channelFields(fields) as C, fields, {
      idFactory: (session: Session) => session.guildId || session.channelId,
      prefix: 'guild',
    });
  }
}

export const { UseCache, UseLock } = new WrapDecoratorBuilder(
  (o) => ((o.ctx || o.__ctx) as Context).aragami,
).build();

export const CommandUserLock = koishiRegistrar.decorateCommandTransformer(
  (ctx, cmd, ...fields: (keyof User)[]) =>
    ctx.aragami.commandUserLock(cmd, fields),
);

export const CommandChannelLock = koishiRegistrar.decorateCommandTransformer(
  (ctx, cmd, ...fields: (keyof Channel)[]) =>
    ctx.aragami.commandChannelLock(cmd, fields),
);

export const CommandGuildLock = koishiRegistrar.decorateCommandTransformer(
  (ctx, cmd, ...fields: (keyof Channel)[]) =>
    ctx.aragami.commandGuildLock(cmd, fields),
);

export const PutLockingUser = koishiRegistrar.decorateCommandPut(
  (info, ...fields: (keyof User)[]) => info.argv.session.user,
  (info, ...fields) => info.ctx.aragami.commandUserLock(info.command, fields),
);

export const PutLockingChannel = koishiRegistrar.decorateCommandPut(
  (info, ...fields: (keyof Channel)[]) => info.argv.session.channel,
  (info, ...fields) =>
    info.ctx.aragami.commandChannelLock(info.command, fields),
);

export const PutLockingGuild = koishiRegistrar.decorateCommandPut(
  (info, ...fields: (keyof Channel)[]) => info.argv.session.guild,
  (info, ...fields) => info.ctx.aragami.commandGuildLock(info.command, fields),
);
