// import 'source-map-support/register';
import { SchemaProperty, RegisterSchema } from 'koishi-thirdeye';
import { AragamiOptions, RedisDriverOptions } from 'aragami';

@RegisterSchema()
export class AragamiRedisConfig implements RedisDriverOptions {
  @SchemaProperty({ description: 'Redis URI. ' })
  uri?: string;
}

@RegisterSchema()
export class AragamiConfig implements AragamiOptions {
  constructor(config: AragamiConfigLike) {}

  @SchemaProperty({ description: 'Redis 配置。' })
  redis?: AragamiRedisConfig;

  getConfig(): AragamiOptions {
    const obj = { ...this };
    if (!Object.getOwnPropertyNames(obj.redis || {}).length) {
      delete obj.redis;
    }
    return obj;
  }
}

export type AragamiConfigLike = AragamiOptions;
