// import 'source-map-support/register';
import { AragamiConfig } from './config';
import {
  DefinePlugin,
  LifecycleEvents,
  PartialDeep,
  PluginSchema,
  Provide,
} from 'koishi-thirdeye';
import { Context } from 'koishi';
import { Aragami, AragamiOptions, WrapDecoratorBuilder } from 'aragami';
export * from './config';
export * from 'aragami';

declare module 'koishi' {
  interface Context {
    aragami: AragamiPlugin;
  }
}

@PluginSchema(AragamiConfig)
@Provide('aragami', { immediate: true })
@DefinePlugin({ name: 'cache-aragami' })
export default class AragamiPlugin extends Aragami implements LifecycleEvents {
  constructor(
    ctx: Context,
    _config: PartialDeep<AragamiConfig> & AragamiOptions,
  ) {
    super(_config.getConfig());
  }

  onDisconnect() {
    return this.destroy();
  }
}

export const { UseCache, UseLock } = new WrapDecoratorBuilder(
  (o) => ((o.ctx || o.__ctx) as Context).aragami,
).build();
