import { Context } from 'koishi';
import TargetPlugin, { UseCache } from '../src';
import { CacheKey, WithKey } from 'aragami';
import { DefinePlugin, Provide, StarterPlugin } from 'koishi-thirdeye';

describe('Test of plugin.', () => {
  let app: Context;

  beforeEach(async () => {
    app = new Context();
    app.plugin(TargetPlugin, {
      // redis: { uri: 'redis://localhost:6379' },
    });
    await app.start();
  });

  class User {
    @CacheKey()
    name: string;
    age: number;
  }

  it('should pass', async () => {
    expect(app.aragami).toBeDefined();
    const user = new User();
    user.name = 'koishi';
    user.age = 18;
    await expect(app.aragami.set(user)).resolves.toBe(user);
    const getUser = await app.aragami.get(User, 'koishi');
    expect(getUser).toEqual(user);
    expect(getUser).toBeInstanceOf(User);
  });

  it('should use wrapping decorator', async () => {
    @Provide('test')
    @DefinePlugin()
    class MyPlugin extends StarterPlugin() {
      @UseCache(User)
      async getUser(@WithKey() name: string, age: number) {
        const user = new User();
        user.name = name;
        user.age = age;
        return user;
      }
    }
    app.plugin(MyPlugin);
    const instance: MyPlugin = app['test'];
    expect(instance).toBeDefined();
    await instance.getUser('Satori', 18);
    await expect(app.aragami.has(User, 'Satori')).resolves.toBeTruthy();
  });
});
