// import 'source-map-support/register';
import { AutoPicPluginConfig } from './config';
import { DefinePlugin, Inject, MultiInstancePlugin } from 'koishi-thirdeye';
import PicsContainer from 'koishi-plugin-pics';
import { SchedulePlugin } from 'koishi-schedule-send';
export * from './config';

@DefinePlugin()
export class AutoPicInstancePlugin extends SchedulePlugin(AutoPicPluginConfig) {
  @Inject(true)
  private pics: PicsContainer;

  async send() {
    const pic = await this.pics.randomPic(
      this.config.tags,
      this.config.sourceTags,
    );
    if (!pic) {
      this.logger.warn(
        `no pic found for ${this.config.tags?.join(',') || '*'} from ${
          this.config.sourceTags?.join(',') || '*'
        }`,
      );
      return;
    }
    return await this.pics.getSegment(pic.url);
  }
}

@DefinePlugin()
export default class AutoPicPlugin extends MultiInstancePlugin(
  AutoPicInstancePlugin,
) {}
