// import 'source-map-support/register';
import { AutoPicPluginConfig } from './config';
import {
  DefinePlugin,
  BasePlugin,
  Inject,
  InjectLogger,
  LifecycleEvents,
  MultiInstancePlugin,
} from 'koishi-thirdeye';
import PicsContainer from 'koishi-plugin-pics';
import { Adapter, Logger } from 'koishi';
import { Job, scheduleJob } from 'node-schedule';
export * from './config';

@DefinePlugin({ name: 'autopic', schema: AutoPicPluginConfig })
export class AutoPicInstancePlugin
  extends BasePlugin<AutoPicPluginConfig>
  implements LifecycleEvents
{
  @Inject(true)
  private pics: PicsContainer;

  @Inject(true)
  private bots: Adapter.BotList;

  @InjectLogger()
  private logger: Logger;

  async run() {
    const pic = await this.pics.randomPic(
      this.config.tags,
      this.config.sourceTags,
    );
    if (!pic) {
      this.logger.warn(
        `no pic found for ${this.config.tags?.join(',') || '*'} from ${
          this.config.sourceTags?.join(',') || '*'
        }`,
      );
      return;
    }
    const message = await this.pics.getSegment(pic.url);
    await Promise.all(
      this.config.targets.map(async (target) => {
        try {
          this.logger.debug(`Sending image ${pic.url} from ${target.bot}.`);
          let targetMessage = message;
          if (this.pics.isOneBotBot(this.bots.get(target.bot))) {
            targetMessage = message.replace(/,url=base64/, ',file=base64');
          }
          const ids = await target.send(this.bots, targetMessage);
          this.logger.debug(
            `Image ${pic.url} sent from ${target.bot}: ${ids?.join(',')}`,
          );
        } catch (e) {
          this.logger.error(
            `Failed to send image ${pic.url} from bot ${
              target.bot
            }: ${e.toString()}`,
          );
        }
      }),
    );
  }

  private job: Job;

  onConnect() {
    if (this.config.immediate) {
      this.run().then();
    }
    this.job = scheduleJob(this.config.cron, () => this.run());
  }

  onDisconnect() {
    this.job.cancel();
  }
}

@DefinePlugin()
export default class AutoPicPlugin extends MultiInstancePlugin(
  AutoPicInstancePlugin,
) {}
