// import 'source-map-support/register';
import { AutoPicPluginConfig, Instance } from './config';
import {
  DefinePlugin,
  BasePlugin,
  Inject,
  InjectLogger,
  LifecycleEvents,
} from 'koishi-thirdeye';
import PicsContainer from 'koishi-plugin-pics';
import { Adapter, Logger, segment } from 'koishi';
import { Job, scheduleJob } from 'node-schedule';
export * from './config';

@DefinePlugin({ name: 'autopic', schema: AutoPicPluginConfig })
export default class AutoPicPlugin
  extends BasePlugin<AutoPicPluginConfig>
  implements LifecycleEvents
{
  @Inject(true)
  private pics: PicsContainer;

  @Inject(true)
  private bots: Adapter.BotList;

  @InjectLogger()
  private logger: Logger;

  async runInstance(instance: Instance) {
    const pic = await this.pics.randomPic(instance.tags, instance.sourceTags);
    if (!pic) {
      this.logger.warn(
        `no pic found for ${instance.tags?.join(',') || '*'} from ${
          instance.sourceTags?.join(',') || '*'
        }`,
      );
      return;
    }
    const message = segment('image', { url: pic.url, cache: true });
    await Promise.all(
      instance.targets.map(async (target) => {
        try {
          this.logger.info(`Sending image ${pic.url} from ${target.bot}.`);
          const ids = await target.send(this.bots, message);
          this.logger.info(
            `Image ${pic.url} sent from ${target.bot}: ${ids?.join(',')}`,
          );
        } catch (e) {
          this.logger.error(
            `Failed to send image ${pic.url} from bot ${
              target.bot
            }: ${e.toString()}`,
          );
        }
      }),
    );
  }

  jobs: Job[] = [];

  onConnect() {
    this.jobs = this.config.instances.map((instance) => {
      if (instance.immediate) {
        this.runInstance(instance).then();
      }
      return scheduleJob(instance.cron, () => this.runInstance(instance));
    });
  }

  onDisconnect() {
    this.jobs.forEach((job) => job.cancel());
    this.jobs = [];
  }
}
