// import 'source-map-support/register';
import { SendTarget } from 'koishi-target-def';
import { SchemaProperty, RegisterSchema } from 'koishi-thirdeye';

@RegisterSchema()
export class Instance {
  @SchemaProperty({ required: true })
  cron: string;

  @SchemaProperty({
    default: false,
    description: '插件启动时是否立即运行一遍。',
  })
  immediate: boolean;

  @SchemaProperty({
    type: String,
    description: '图片标签。见 koishi-plugin-pics 文档。',
  })
  tags: string[];

  @SchemaProperty({
    type: String,
    description: '图源标签。见 koishi-plugin-pics 文档。',
  })
  sourceTags: string[];

  @SchemaProperty({
    type: SendTarget,
    description: '图片发送目标。',
  })
  targets: SendTarget[];
}

@RegisterSchema()
export class AutoPicPluginConfig {
  constructor(config: AutoPicPluginConfigLike) {}

  @SchemaProperty({ type: Instance })
  instances: Instance[];
}

export type AutoPicPluginConfigLike = Partial<AutoPicPluginConfig>;
