import { ApiSendPluginConfig } from './config';
import {
  DefinePlugin,
  Inject,
  InjectLogger,
  KoaContext,
  Post,
  Reusable,
  StarterPlugin,
} from 'koishi-thirdeye';
import { Bot, Logger } from 'koishi';
export * from './config';

@Reusable()
@DefinePlugin({ name: 'apisend' })
export default class ApiSendPlugin extends StarterPlugin(ApiSendPluginConfig) {
  @Inject(true)
  private bots: Bot[];

  @InjectLogger()
  private logger: Logger;

  @Post('{{path}}')
  private async send(ctx: KoaContext) {
    if (this.config.token) {
      let authorization = ctx.request.headers.authorization;
      if (authorization.startsWith('Bearer ')) {
        authorization = authorization.slice(7);
      }
      if (authorization !== this.config.token) {
        ctx.status = 403;
        ctx.body = { error: 'Invalid token' };
        return;
      }
    }
    const { content } = ctx.request.body;
    if (!content) {
      ctx.status = 400;
      ctx.body = { error: 'Empty content' };
      return;
    }
    try {
      const messageIds = await Promise.all(
        this.config.targets.map((t) => t.send(this.bots, content)),
      );
      ctx.body = { messageIds: messageIds.flat(1) };
      ctx.status = 200;
    } catch (e) {
      const error = `Error: ${e.message}`;
      this.logger.error(error);
      ctx.status = 500;
      ctx.body = { error };
    }
  }
}
