import { SendTarget } from 'koishi-target-def';
import { SchemaProperty, RegisterSchema } from 'koishi-thirdeye';

@RegisterSchema()
export class ApiSendPluginConfig {
  constructor(config: ApiSendPluginConfigLike) {}

  @SchemaProperty({ description: '接口路径。', required: true })
  path: string;

  @SchemaProperty({ description: '接口 Token。', role: 'secret' })
  token: string;

  @SchemaProperty({ description: '发送目标。', type: SendTarget })
  targets: SendTarget[];
}

export type ApiSendPluginConfigLike = Partial<ApiSendPluginConfig>;
