// import 'source-map-support/register';
import { ApiPluginConfig, ApiPluginConfigLike } from './config';
import {
  DefinePlugin,
  InjectConfig,
  KoaContext,
  PluginSchema,
  Post,
  Reusable,
  ReplySession,
} from 'koishi-thirdeye';
import { Bot, Context, Fragment, Random } from 'koishi';

export * from './config';

@Reusable()
@PluginSchema(ApiPluginConfig)
@DefinePlugin()
export default class ApiBot extends Bot {
  username = 'koishi';
  selfId = 'koishi';
  hidden = true;

  constructor(public ctx: Context, config: ApiPluginConfigLike) {
    super(ctx, { platform: 'api', selfId: config.selfId });
  }

  @InjectConfig()
  private pluginConfig: ApiPluginConfig;

  @Post('{{path}}')
  private async onHttpPost(ctx: KoaContext) {
    if (this.pluginConfig.token) {
      const header = ctx.request.headers['authorization'];
      const tokenFromRequest = header?.startsWith('Bearer ')
        ? header.slice(7)
        : header;
      if (tokenFromRequest !== this.pluginConfig.token) {
        ctx.status = 401;
        ctx.body = { error: 'Invalid token' };
        return;
      }
    }
    if (typeof ctx.request.body === 'string') {
      ctx.status = 400;
      ctx.body = { error: 'Invalid body' };
      return;
    }
    const body = ctx.request.body;
    if (!body.content) {
      ctx.status = 400;
      ctx.body = { error: 'Missing content.' };
      return;
    }
    const userId = body.userId || ctx.request.ip;
    const session = new ReplySession(this, {
      userId,
      channelId: body.channelId || `private:${userId}`,
      guildId: body.guildId,
      messageId: body.messageId || Random.id(),
      content: body.content,
      platform: 'api',
      selfId: 'koishi',
      type: 'message',
      subtype: body.channelId ? 'group' : 'private',
      author: {
        userId,
        avatar: body.avatar,
        username: body.username || userId,
      },
    });
    if (!this.ctx.filter(session)) {
      ctx.status = 200;
      ctx.body = { messages: [] };
      return;
    }
    ctx.status = 200;
    ctx.body = {
      messages: (await session.process()).map((e) => e.toString()),
    };
  }

  async sendMessage(channelId: string, content: Fragment) {
    return [];
  }

  async sendPrivateMessage(userId: string, content: Fragment) {
    return [];
  }
}

export interface MessageBody {
  channelId?: string;
  guildId?: string;
  messageId?: string;
  content: string;
  userId?: string;
  username?: string;
  avatar?: string;
}
