import { getSessionId, Random, Session } from 'koishi';
import ApiBot from './index';
import { Prompt } from './def/prompt';

export class ApiSession extends Session {
  storedMessages: string[] = [];
  private midResolver: () => void;
  bot: ApiBot;
  currentPromise: Promise<void>;

  midPromise = new Promise<void>((resolve) => {
    this.midResolver = resolve;
  });

  async waitForPattern() {
    await Promise.race([
      this.currentPromise.then(() => this.midResolve(true)),
      this.midPromise,
    ]);
    return this.gatherResponseMessages();
  }

  midResolve(finish = false) {
    if (!this.midResolver) {
      return;
    }
    this.midResolver();
    if (finish) {
      delete this.midResolver;
    } else {
      this.midPromise = new Promise<void>((resolve) => {
        this.midResolver = resolve;
      });
    }
  }

  async send(content: string) {
    this.storedMessages.push(content);
    return [Random.id()];
  }

  gatherResponseMessages() {
    const result = this.storedMessages.filter((m) => !!m);
    this.storedMessages = [];
    return result;
  }

  prompt(timeout = this.app.options.delay.prompt) {
    const identifier = getSessionId(this);
    const prom = new Promise<string>((resolve) => {
      const prompt: Prompt = {
        resolver: resolve,
        timeout: setTimeout(() => {
          this.bot.resolvePrompt(identifier, undefined);
        }, timeout),
        session: this,
      };
      this.bot.prompts.set(identifier, prompt);
    });
    this.midResolve();
    return prom;
  }
}
